# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 3
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR3_strategy.txt
# LLM Suggested Fallback: C

def harmonious_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:  # First round
        return "C"
    
    total_rounds = len(my_history) + 1
    last_opp_move = opp_history[-1]
    
    # Detect simple opponent patterns
    always_c = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code
    always_d = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code
    
    if always_c:
        return "D" if total_rounds > 1 else "C"
    if always_d:
        return "D"
    
    # Phased strategy
    if total_rounds <= 3:
        return "C"
    elif total_rounds <= 7:
        if all(move == "C" for move in opp_history):
            return "C"
        else:
            return last_opp_move
    else:  # Rounds 8-10
        if opp_history.count("D") > 1:
            return "D"
        else:
            return "C"